@echo off
:: https://stackoverflow.com/questions/67539331/what-am-i-doing-wrong-using-the-choice-command-with-batch
::
:: AppFileName:	WinSetupMenu.bat
:: Date:		2025-03-17 05:40:25
:: Version:		1.25.03.17
:: Author(rewrite):		lsl
::
rem ====	基本系統設定 set 一定要加""避免空白
set "Driver=%~d0"
set "FilePath=%~p0"
set "ConfFile=%~n0"
set "FullPath=%~dp0"
set "FullPathFile=%~f0"

rem ====----	IsAdmin
call :IsAdmin
call :ChkWbem_WMIC

setlocal EnableDelayedExpansion
call :GetBaseBoard
call :GetCPUName
call :GetMemphysical
call :GetMemoryChip
call :GetVideoController
call :GetDiskDrive

call :GetWinOSName

cd /D "%Driver%%FilePath%"

TITLE WinSetup Dynamic menu system
echo.[104mWinSetupMenu[0m
call :SelectMenu "End" "Win_ISO.bat" "ListPartition.bat" "CreatePartitions.bat" "EditInstall.bat" "install_wim.cmd" "RemovesVolume.bat"
call :GetChose

pause
goto :End

rem :: ONLY FUNCTIONS BELOW HERE

:SelectMenu
	echo.[92m %~0 [0m
	set /a "OptionNo=0"
	set "SelectNum="
	For %%I in (%*) do (
		set /a OptionNo+=1
		call :ResolveChar !OptionNo!
		set "Option!ReturnValue!=%%~I"
		set "SelectNum=!SelectNum!!ReturnValue!"
		echo [!ReturnValue!] [93m %%~I [0m
	)
	goto :Eof

:ResolveChar
	setlocal
	set "keys=_e0123456789"
	set "_StartChar=%1"
	call set "GetkeyInChar=%%keys:~%_StartChar%,1%%"
	endlocal & set "ReturnValue=%GetkeyInChar%"
	goto :Eof

:GetChose
	choice /c !SelectNum! /cs /m "Select Your Option: " /n
	call :ResolveChar %errorlevel%
	set "Option=!Option%ReturnValue%!"
	echo You Selected: %ReturnValue% - [92m%Option%[0m

	if /I %ReturnValue% EQU E (
		exit /b
	) else (
		call %Option% c
		call :SelectMenu "End" "Win_ISO.bat" "ListPartition.bat" "CreatePartitions.bat" "EditInstall.bat" "install_wim.cmd" "RemovesVolume.bat"
	)
	goto :GetChose

:ChkWbem_WMIC
	if not exist "%SystemRoot%\System32\wbem\WMIC.exe" (
		if exist "%SystemDrive%\PortableApps\wbem\WMIC.exe" (
			cd /D "%SystemDrive%\PortableApps\wbem\"
			exit /b
		) else (
			call :Checkdir %SystemDrive%\PortableApps\wbem\
			if not exist "%Driver%%FilePath%wbem\WMIC.exe" (
				curl.exe -LJR --url "https://www.maes.idv.tw/download/Files/Win10_Programs/Win_11/wbem_WMIC/Windows24H2_wbem_WMIC.zip" --output "%SystemDrive%\PortableApps\Windows24H2_wbem_WMIC.zip"  -k --show-error --fail --no-progress-meter
				%ComSpec% /C powershell "Expand-Archive -Path %SystemDrive%\PortableApps\Windows24H2_wbem_WMIC.zip -DestinationPath '%SystemDrive%\PortableApps\'" -Force
				cd /D "%SystemDrive%\PortableApps\wbem\"
			)
		)
	)
	exit /b

:GetBaseBoard
	echo [42m%~0[0m
	cd C:\PortableApps\wbem

	set "WMICBaseBoard_txt=%temp%\WMICBaseBoard_txt"
	set "WMICBaseBoardSort_txt=%temp%\WMICBaseBoardSort_txt"
	
	WMIC.exe BaseBoard get Product , Manufacturer /format:csv >%WMICBaseBoard_txt%
	type %WMICBaseBoard_txt% | sort>%WMICBaseBoardSort_txt%
	
	For /F "tokens=2-5 delims=," %%I in ('findstr "[0-9]"  "%WMICBaseBoardSort_txt%" ') do (
		set "BoardManufacturer=%%I"
		set "BoardProduct=%%J"		
	)
	set "BoardProduct=%BoardProduct: =_%"
	set "BoardProduct=%BoardProduct:__=%"

	echo BaseBoardProduct=!BoardProduct!
	echo BaseBoardManufacturer=!BoardManufacturer!
	
	exit /b

:GetCPUName
	echo [42m%~0[0m
	For /F "tokens=1-9 skip=1 delims= " %%I in ( 'WMIC.exe CPU get Name ^| findstr "." ') do (
		set "CPUName=%%I %%M"
	)
	echo CPUName=!CPUName!
	exit /b

:GetMemphysical
	echo [42m%~0[0m
	For /F "tokens=1-2 skip=1 delims= " %%I in ( 'WMIC.exe Memphysical get MaxCapacity ^, MemoryDevices ^| findstr "." ') do (
		set /a II=%%I
		rem set /a III=!II!/1048576
		set "MemphysicalMaxCapacity=%%I"
		set "MemphysicalDevices=%%J"
	)
	echo MemphysicalMaxCapacity=!MemphysicalMaxCapacity!
	echo MemphysicalDevices=!MemphysicalDevices!
	exit /b

:GetMemoryChip
	echo [42m%~0[0m
	set /a n=0
	set MemoryChip=
	For /F "tokens=1-5 skip=1 delims= " %%I in ( 'WMIC.exe MemoryChip get Capacity ^, Tag ^, PartNumber ^| findstr "." ') do (
		set "MemoryChip_!n!=%%I"
		echo MemoryChip_!n!=%%I %%J %%K %%L %%M		
		set /a n+=1
	)
	exit /b

:GetVideoController
	echo [42m%~0[0m
	for /F "tokens=* skip=1" %%n in ('WMIC path Win32_VideoController get Name ^| findstr "."') do (
		set GPU_NAME=%%n
		echo VideoController=!GPU_NAME!
	)
	exit /b

:GetDiskDrive
	echo [42m%~0[0m
	set "WMICDiskDrive_txt=%temp%\WMICDiskDrive_txt"
	set "WMICDiskDriveSort_txt=%temp%\WMICDiskDriveSort_txt"
	
	WMIC.exe DiskDrive get DeviceID, Model, Partitions, Size /format:csv >%WMICDiskDrive_txt%
	type %WMICDiskDrive_txt% | sort>%WMICDiskDriveSort_txt%

	For /F "tokens=2-5 delims=," %%I in ('findstr "[0-9]"  "%WMICDiskDriveSort_txt%" ') do (
		set "II=%%I"
		set "II=!II:\\.\PHYSICALDRIVE=Drive_!"
		set "JJ=%%J                       "
		set "JJ=!JJ:~0,40!"
		
		set "LL=%%L"
		set "LL=!LL:~0,-6!"
		set /a LLL=!LL!/1000
		set "LLLL=       !LLL!"
		set "LLL=!LLLL:~-8!"
		
		echo !II!_Model=!JJ!	!LLL! GB
	)
	exit /b
	
:GetWinOSName
	echo [42m%~0[0m
	For /F "tokens=1-9 skip=1 delims=| " %%I in ( 'WMIC.exe OS get Name ^, Version ^, InstallDate ^, TotalVisibleMemorySize ^| findstr "." ') do (
		set WinOSName=%%K %%L %%M
		rem echo %%I %%J %%K %%L %%M %%N %%O %%P %%Q
		set WinOSDevice=%%O
		set WinOSVersion=%%Q
		set WinOSInstallDate=%%I
		set WinOSMemorySize=%%P

	)

	echo OSName=!WinOSName!
	echo OSVersion=!WinOSVersion!
	echo OSDevice=!WinOSDevice:~7!
	echo OSInstallDate=!WinOSInstallDate!
	echo OSMemorySize=!WinOSMemorySize!
	exit /b

:IsAdmin
	reg.exe query "HKU\S-1-5-19\Environment" >nul
	if not %ERRORLEVEL% EQU 0 (
		echo 必須「以系統管理員身分執行」
		echo You must have administrator rights to continue ...
		pause & exit
	)
	exit /b

:Eof

:End
	cd /D "%Driver%%FilePath%"
	%ComSpec% /k