@echo off
:: ===============================================================================
:: AppFileName:	install_wim.cmd
:: Date:		2025-03-15 07:43:53
:: Version:		1.25.03.15
:: Author:		lsl
::
:: WinSources\ApplyImage
:: WinSources\CreatePartitions
:: WinSources\Drivers
:: WinSources\oobe
:: WinSources\Packages
:: WinSources\Recovery
:: WinSources\sources
::
:: HDModel_0=SSDDisk
:: WinVer_0=Win11_24H2
:: PCModel_0=Windows11
:: ===============================================================================
::
rem ====----	EndCmd	1 not 3
if "%~1"=="" (
	set "EndCmd=k"
) else (
	set "EndCmd=c"
)

rem ====----	IsAdmin
rem ====	򥻨tγ]w set @wn[""קKť
set "Driver=%~d0"
set "FilePath=%~p0"
set "ConfFile=%~n0"
set "FullPath=%~dp0"
set "FullPathFile=%~f0"

rem ====----	IsAdmin
call :IsAdmin

cd /D "%Driver%%FilePath%"
rem ==--

call :ColorSet

rem ====----	Initialize Variable
call :iniVariable

setlocal enabledelayedexpansion

call :GetInstallWimVer

call :CreateiniFile

rem ====----	Read ini File
call :ReadiniFile

rem ====----	initialize	Set Path Variable
call :SetVariable

rem ::	Windows 24H2
call :ChkWbem_WMIC

call :Run_WMIC
call :GetProductName
call :GetWinOSVer

call :GetWMICDiskMsg

goto End

:GetInstallWimVer
	set IsInstallWim=0
	echo|set /p="[45m"
	echo GetInstallWimVer[0m

	For /F "tokens=*"  %%I in ('dir install.wim/b/s') do (
		if /I exist %%I (
			set Win_Name=%%I
			set Win_Name=!Win_Name:~-38,2!

			set Win_Created=%%I
			set Win_Created=!Win_Created:~-35,4!

			set Win_Version=%%I
			set Win_Version=!Win_Version:~-30,10!

			set "Win_Ver=Win!Win_Name!_!Win_Created!_!Win_Version!"
			rem echo.!Win_Ver!

			if !Win_Name! EQU 11 (
				set Win11_Ver=!Win_Ver!
				echo.!Win11_Ver!
			)

			if !Win_Name! EQU 10 (
				set Win10_Ver=!Win_Ver!
				echo.!Win10_Ver!
			)
			set IsInstallWim=1
		)
	)
	if !IsInstallWim! EQU 0 (
		if not defined Win11_Ver (
			echo.Can not find Win11 install.wim
			echo Download Windows11 : https://www.microsoft.com/software-download/windows11
		)
		if not defined Win10_Ver (
			echo.Can not find Win10 install.wim
			echo Download Windows10 : https://www.microsoft.com/software-download/windows10
		)
		echo.
		echo 1.Download Windows ISO File
		echo 2.mount ISO File
		echo 3.Run Win_ISO.bat
		goto End
	)

	exit /b

:iniVariable
	set HDModelSet=
	set WinVerSet=
	set PCModelSet=
	exit /b

:CreateiniFile
	if not exist "%Driver%%FilePath%%ConfFile%.txt" (
		echo.>"%Driver%%FilePath%%ConfFile%.txt"
		echo.HDModel_0=SSDDisk>>"%Driver%%FilePath%%ConfFile%.txt"
		echo.# WinVer_0=Win11>>"%Driver%%FilePath%%ConfFile%.txt"
		echo.# PCModel_0=ASUS_B760PC>>"%Driver%%FilePath%%ConfFile%.txt"
	)
	exit /b

:ReadiniFile
	rem ====----	setlocal enabledelayedexpansion
	rem ====----	Read ini File
	rem ====	it()
	rem xxx set "FilePath=%O_FilePath:^(=^^(%"
	rem xxx set "FilePath=%O_FilePath:^)=^^)%"
	echo|set /p="[45m"
	echo ReadiniFile[0m
	echo|set /p="%Driver%%FilePath%%ConfFile%.txt"[0m
	echo|set /p="[0m"
	echo.
	rem  path
	For /F "tokens=1* delims==" %%I in ('findstr /i "^[A-z]" "%Driver%%FilePath%%ConfFile%.txt"') do (
		rem echo %%I=%%J
		set "%%I=%%J"
		rem ====	2024-08-28	()
		if defined %%I (
			if defined %%J (
				rem echo defined
				set JJ=%%J
				set "%%I=!JJ:^)=^^)!"
			)
		)
	)
	echo.
	exit /b

:SetVariable
	rem set "HDModel_n=HDModel_%~1"
	set "p1=%~1"
	set "p2=%~2"

	For /F "tokens=1* delims==" %%M in ('findstr /I /B "/C:!p1!_!p2!" "%Driver%%FilePath%%ConfFile%.txt"') do (
		set "%%M=%%N"

		rem ====	2024-08-28	()
		if defined %%M (

			set NN=%%N
			if /I %%N EQU Win10 (
				if defined Win10_Ver (
					set NN=%Win10_Ver%
				) else (
					set "NN=[0m[42m%%N[0m		"
				)
			)
			if /I %%N EQU Win11 (
				if defined Win11_Ver (
					set NN=%Win11_Ver%
				) else (
					set "NN=[0m[42m%%N[0m		"
				)
			)

			set "!p1!Set=!NN:^)=^^)!"
		) else (
			set !p1!Set=
		)
	)
	exit /b

:Run_WMIC
	set WMICTempFile=%temp%\WMICDiskDrive.txt
	set WMICTempFileSort=%temp%\WMICDiskDriveSort.txt
	WMIC.exe DiskDrive get DeviceID, Model, Partitions, Size /format:csv >%WMICTempFile%
	type %WMICTempFile% | sort>%WMICTempFileSort%

	echo [45mWMIC DiskDrive[0m
	WMIC.exe DiskDrive get DeviceID, Model, Partitions, Size
	exit /b

:GetWMICDiskMsg
	echo|set /p="[45m"
	echo GetWMICDiskMsg[0m
	echo.
	echo|set /p="[0m"

	setlocal enabledelayedexpansion
	For /F "tokens=2-5 delims=," %%I in ('findstr "[0-9]"  "%temp%\WMICDiskDriveSort.txt" ') do (

		call :iniVariable

		set II=%%I
		set JJ=%%J
		set KK=%%K

		set "II=!II:\\.\PHYSICALDRIVE=!"
		call :SetVariable PCModel !II!
		call :SetVariable HDModel !II!
		call :SetVariable WinVer !II!

		set LL=%%L
		set LL=!LL:~0,-6!
		set /a LLL=!LL!/1000

		if defined HDModelSet (
			echo|set /p="[45m"
			echo GetWMICDiskMsg HDModelSet[0m
			echo|set /p="[0m"
			if not defined PCModelSet (
				set "PCModelSet=%ProductName%"
			)

			if not defined WinVerSet (
				set "WinVerSet=!Win11_Ver!"
			)

			echo ID	Part	Size		PCModelSet	HDModelSet	WinVerSet		Model
			echo [92m!II!	!KK!	!LLL! GB		!PCModelSet!	!HDModelSet!		!WinVerSet!	!JJ![0m

			call :DiskPartCmd !II! !PCModelSet! !HDModelSet! !WinVerSet!
			call :DiskPartTxt !II! !PCModelSet! !HDModelSet! !WinVerSet!
			call :CopyApplyImage  !II! !PCModelSet! !HDModelSet! !WinVerSet!
			echo.

			call :DiskPartCmd !II! !PCModelSet! !HDModelSet! !WinVerSet! boot
			call :DiskPartTxt !II! !PCModelSet! !HDModelSet! !WinVerSet! boot
			call :CopyApplyImage  !II! !PCModelSet! !HDModelSet! !WinVerSet! boot
			echo.
		)
	)
	setlocal
	exit /b

:GetProductName
	cd C:\PortableApps\wbem
	For /F "tokens=* skip=1"  %%I in ( 'WMIC.exe BaseBoard get Product ^| findstr "."') do (
		set product=%%I
	)
	set "ProductName=%product: =_%"
	set "ProductName=%ProductName:__=%"
	rem echo "%ProductName%"
	exit /b

:GetWinOSVer
	For /F "tokens=1-5 delims=| "  %%I in ( 'WMIC.exe OS get Name ^| findstr /I /C:Windows') do (
		set WinOSVer=%%K
	)
	set "WinOSVer=!WinOSVer!"
	exit /b

:DiskPartCmd
	set "Disk_n=%~1"
	set "PCModelName=%~2"
	set "HDModelName=%~3"
	set "WinVersion=%~4"
	set "IsBoot=%~5"
	:: echo %FullPath%%ConfFile%_%PCModelName%\%HDModelName%

	call :Checkdir %FullPath%%ConfFile%_%PCModelName%\%HDModelName%
	if defined IsBoot (
		set "DiskPartFile=%FullPath%%ConfFile%_%PCModelName%\%HDModelName%\Disk%Disk_n%_%HDModelName%_boot.cmd"
		set "DiskPartBatFile=%FullPath%%ConfFile%_%PCModelName%\%HDModelName%\Disk%Disk_n%_%HDModelName%_boot.bat"
	) else (
		set "DiskPartFile=%FullPath%%ConfFile%_%PCModelName%\%HDModelName%\Disk%Disk_n%_%HDModelName%.cmd"
		set "DiskPartBatFile=%FullPath%%ConfFile%_%PCModelName%\%HDModelName%\Disk%Disk_n%_%HDModelName%.bat"
	)

	echo.[93m%DiskPartFile%[0m
	echo.@echo off >"%DiskPartFile%"

	if defined IsBoot (
		echo.rem :: Disk%Disk_n%_%HDModelName%_boot.bat >>"%DiskPartFile%"
	) else (
		echo.rem :: Disk%Disk_n%_%HDModelName%.bat >>"%DiskPartFile%"
	)
	echo.rem :: %Disk_n% %HDModelName% %WinVersion% >>"%DiskPartFile%"
	echo.set "FullPath=%%~dp0" >>"%DiskPartFile%"
	echo.set "ConfFile=%%~n0" >>"%DiskPartFile%"
	echo.call "%%FullPath%%%%ConfFile%%.bat"  %Disk_n% %HDModelName% %WinVersion% >>"%DiskPartFile%"
	echo.%%ComSpec%% /k >>"%DiskPartFile%"
	exit /b

:DiskPartTxt
	set "Disk_n=%~1"
	set "PCModelName=%~2"
	set "HDModelName=%~3"
	set "WinVersion=%~4"
	set "IsBoot=%~5"

	call :Checkdir %FullPath%%ConfFile%_%PCModelName%\%HDModelName%
	if defined IsBoot (
		set "DiskPartFile=%FullPath%%ConfFile%_%PCModelName%\%HDModelName%\Disk%Disk_n%_%HDModelName%_boot.txt"
	) else (
		set "DiskPartFile=%FullPath%%ConfFile%_%PCModelName%\%HDModelName%\Disk%Disk_n%_%HDModelName%.txt"
	)

	echo.%DiskPartFile%
	echo. >"%DiskPartFile%"
	echo.rem :: diskpart >>"%DiskPartFile%"
	if defined IsBoot (
		echo.rem   ##	 DiskPart /s "B:\Disk%Disk_n%_%HDModelName%_boot.txt" 	## >>"%DiskPartFile%"
	) else (
		echo.rem   ##	 DiskPart /s "B:\Disk%Disk_n%_%HDModelName%.txt" 	## >>"%DiskPartFile%"
	)
	echo.select disk=%Disk_n% >>"%DiskPartFile%"
	echo.>>"%DiskPartFile%"
	echo.select partition=2 >>"%DiskPartFile%"
	echo.format quick fs=fat32 label="SYS_%HDModelName%" OverRide NoErr>>"%DiskPartFile%"
	echo.assign letter=S NoErr>>"%DiskPartFile%"
	echo.>>"%DiskPartFile%"
	echo.select partition=3 >>"%DiskPartFile%"
	echo.rem format quick fs=ntfs label="Win_%HDModelName%" OverRide NoErr>>"%DiskPartFile%"
	echo.assign letter=W NoErr>>"%DiskPartFile%"
	echo.>>"%DiskPartFile%"
	echo.select partition=4 >>"%DiskPartFile%"
	if defined IsBoot (
		echo.rem format quick fs=ntfs label="Recovery_%HDModelName% OverRide NoErr" >>"%DiskPartFile%"
	) else (
		echo.format quick fs=ntfs label="Recovery_%HDModelName%" OverRide NoErr>>"%DiskPartFile%"
	)
	echo.>>"%DiskPartFile%"
	echo.assign letter=R NoErr>>"%DiskPartFile%"
	exit /b

:CopyApplyImage
	set "Disk_n=%~1"
	set "PCModelName=%~2"
	set "HDModelName=%~3"
	set "WinVersion=%~4"
	set "IsBoot=%~5"

	call :Checkdir %FullPath%%ConfFile%_%PCModelName%\%HDModelName%
	if defined IsBoot (
		set "DiskPartFile=%FullPath%%ConfFile%_%PCModelName%\%HDModelName%\Disk%Disk_n%_%HDModelName%_boot.bat"
	) else (
		set "DiskPartFile=%FullPath%%ConfFile%_%PCModelName%\%HDModelName%\Disk%Disk_n%_%HDModelName%.bat"
	)

	echo %DiskPartFile%
	if defined IsBoot (
		copy /Y "%Driver%%FilePath%WinSources\ApplyImage\ApplyImage_boot.txt" "%DiskPartBatFile%" >NUL
	) else (
		copy /Y "%Driver%%FilePath%WinSources\ApplyImage\ApplyImage.txt" "%DiskPartBatFile%" >NUL
	)
	exit /b

:ColorSet
	::	1 Normal Text
	set "ClolorBlack_NT=[30m"
	set "ClolorRed_NT=[31m"
	set "ClolorGreen_NT=[32m"
	set "ClolorYellow_NT=[33m"
	set "ClolorBlue_NT=[34m"
	set "ClolorMagenta_NT=[35m"
	set "ClolorCyan_NT=[36m"
	set "ClolorWhite_NT=[37m"

	::	2 Normal Background
	set "ClolorBlack_NB=[40m"
	set "ClolorRed_NB=[41m"
	set "ClolorGreen_NB=[42m"
	set "ClolorYellow_NB=[43m"
	set "ClolorBlue_NB=[44m"
	set "ClolorMagenta_NB=[45m"
	set "ClolorCyan_NB=[46m"
	set "ClolorWhite_NB=[47m"

	::	3 Bright Text
	set "ClolorBlack_BT=[90m"
	set "ClolorRed_BT=[91m"
	set "ClolorGreen_BT=[92m"
	set "ClolorYellow_BT=[93m"
	set "ClolorBlue_BT=[94m"
	set "ClolorMagenta_BT=[95m"
	set "ClolorCyan_BT=[96m"
	set "ClolorWhite_BT=[97m"

	::	4 Bright Background
	set "ClolorBlack_BB=[100m"
	set "ClolorRed_BB=[101m"
	set "ClolorGreen_BB=[102m"
	set "ClolorYellow_BB=[103m"
	set "ClolorBlue_BB=[104m"
	set "ClolorMagenta_BB=[105m"
	set "ClolorCyan_BB=[106m"
	set "ClolorWhite_BB=[107m"

	::	0 DefaultClolor
	set "DefaultClolor=[0m"

	exit /b

:ColorMsg
	echo|set /p=[0m
	exit /b

:Checkdir
	rem ====----	https://stackoverflow.com/questions/18639663/how-to-pass-command-line-parameters-with-space-in-batch-file
	if exist "%*" (
		exit /b
	)
	if not exist "%*" (
		mkdir "%*"
		exit /b
	)
	if exist "%*" (
		echo %* Created
		exit /b
	)
	exit /b

:7z
	rem ====----	parameters 1 2 3 4
	rem ====	mode file outpath file
	if exist %2 (
		echo "%ProgramFiles%\7-Zip\7z.exe" %1 -y %2 -o%3 %4 -p%password% -aoa
		"%ProgramFiles%\7-Zip\7z.exe" %1 -y %2 -o%3 %4 -p%password% -aoa
	) else (
		echo %2
		goto End
	)
	exit /b

:ChkWbem_WMIC
	if not exist "%SystemRoot%\System32\wbem\WMIC.exe" (
		if exist "%SystemDrive%\PortableApps\wbem\WMIC.exe" (
			cd /D "%SystemDrive%\PortableApps\wbem\"
			exit /b
		) else (
			call :Checkdir %SystemDrive%\PortableApps\wbem\
			if not exist "%Driver%%FilePath%wbem\WMIC.exe" (
				curl.exe -LJR --url "https://www.maes.idv.tw/download/Files/Win10_Programs/Win_11/wbem_WMIC/Windows24H2_wbem_WMIC.zip" --output "%SystemDrive%\PortableApps\Windows24H2_wbem_WMIC.zip"  -k --show-error --fail --no-progress-meter
				%ComSpec% /C powershell "Expand-Archive -Path %SystemDrive%\PortableApps\Windows24H2_wbem_WMIC.zip -DestinationPath '%SystemDrive%\PortableApps\'" -Force
				cd /D "%SystemDrive%\PortableApps\wbem\"
			)
		)
	)
	exit /b

:IsAdmin
	reg.exe query "HKU\S-1-5-19\Environment" >nul
	if not %ERRORLEVEL% EQU 0 (
		echo uHtκ޲zv
		echo You must have administrator rights to continue ...
		pause & exit
	)
	exit /b

:End
	cd /D "%Driver%%FilePath%"
	%ComSpec% /%EndCmd%

