# 讀音選擇工具

本工具可輔助使用者選擇全篇文章裡每個破音字。
選擇完畢後，可直接複製到Word、Power Point、Illustrator等應用程式使用。

## 使用方式

* 用瀏覽器開啟 index.html，貼上想要選擇注音的文章，然後按下「開始」。
* 多音字會以黃色底顯示，您可點下方的箭頭移到前/後一個多音字。或直接點選想要選擇讀音的字。
* 本工具會自動猜測一些破音字的讀音，並以粉紅底顯示。
* 手動選擇過讀音的文字，會以綠底顯示。
* 全部選完以後，按「完成」，複製文章到其它應用程式。

依照目前的規格，本工具不善常推測下面這類破音，請小心注意選擇：

* 「一」、「不」這類變音字。
* ㄦ化韻的「兒」字。
* 連接詞的「和」字。
* 單一音節的動詞。
* 文言文、古文的讀音。

## 詞庫編輯標準

本詞庫目前原則上收錄《國語一字多音審訂表(初稿)》的讀音。

## 查字典

在按下 「開始」 後的編輯模式中，點選右下角 「字典」 可開啟 《國語字典簡編本》 輔助查詢字義與教育部標準讀音。
請用滑鼠點擊或選取任意字詞，字典工具會即時顯示查詢結果。

## 協作邀請 (詞庫)

poyin_db.txt 收錄了所有 phonetic/phonic_table_Z.txt 裡所有多音字的每個讀音。
每個讀音後，列出一連串用/隔開的詞彙（這個字本身以*表示）。

如：

	[仔] ㄗˇ
	[仔] ㄗㄞˇ	打*/牛*/公*/豬*

這樣表示碰到「打仔」、「牛仔」、「公仔」等詞，讀成「ㄗㄞˇ」的音。

當比對不到任何符合的讀音時，就不會自動選擇讀音（而顯示成預設的第一讀音，也就是沒有IVS的預設讀音），所以第一讀音的詞並不用積極列出，甚至空著也無妨。


當《國語一字多音審訂表》規定的讀音可能不符合一般習慣時，則建議可試著在第一讀音列出。

	[騎] ㄑㄧˊ	*兵
	[騎] ㄐㄧˋ	驃*/輕*/坐*

例如「騎」讀成「ㄑㄧˊ」時是第一讀音，像「騎馬」、「騎車」、「騎乘」這些詞彙，為了避免繁瑣，都不需特別列出。然而由於「騎兵」早年可能有人唸成ㄐㄧˋ兵，但《國語一字多音審訂表》所規定的讀音是ㄑㄧˊ，所以特別列出來，這樣在工具裡會顯示成自動選擇，可提醒使用者注意。


當您編輯完 poyin_db.txt 後，執行 poyin_db.rb（需要Ruby環境與phonetic目錄），可以自動生成出選擇工具使用的 JavaScript 檔案 poyin_db.js。

可開啟讀音選擇工具試用自己編輯的結果是否合適。

歡迎協助編輯 poyin_db.txt，並送出 Pull Request。

## 協作邀請 (程式)

若您對本選擇工具的演算法、資料格式有更好的構想，也歡迎分享您其它版本的選擇工具。

例如目前版本對於「一」、「不」等變音字也只能靠詞庫窮舉，或許可以讀入完整讀音檔案，從下一個字的聲調去判斷等等。

另外，本注音字型規格其實還有提供U+E01E0異體，可顯示為不帶注音符號（只有國字部分）。不過此輸入工具目前尚未支援選擇這個模式。

## 協作邀請 (字典)

本工具字典檔資料來自於教育部國語辭典公眾授權網 《<a href="https://language.moe.gov.tw/001/Upload/Files/site_content/M0001/respub/dict_concised_download.html">國語辭典簡編本</a>》，採用 CC BY-ND 3.0 授權。

字典工具來自開源的字典架構 <a href="https://github.com/jeffreyxuan/ToneOZDic">ToneOZ 澳聲通字典</a>，採用 MIT 授權。
此字典工具支援使用者自行製作字典檔，請參考 <a href="https://github.com/jeffreyxuan/ToneOZDic/blob/main/README.md">ToneOZ Dictionary 字典檔生成器使用說明</a>。


歡迎 Pull Request，或自行 fork 新專案。
