@echo off
:: ===============================================================================
:: AppFileName:	ChkWbem_WMIC.cmd
:: Date:		2024-10-09 23:01:09
:: Version:		1.24.10.09
:: Author:		lsl
::
:: Copy 	source(S_) to target(T_)
:: cmd type Window (_W) Linux (_L)
:: driver O_ (Original) L_ (Last)
:: ===============================================================================
::
::	2024-09-22
call :IsAdmin
call :ColorSet
set Driver=%~d0
set FilePath=%~p0
set ConfFile=%~n0
set O_SystemDrive=%SystemDrive%

	call :ChkWbem_WMIC
	call :Create_TempFile

	WMIC.exe LogicalDisk where ^( DriveType^<5 ^) get Description,DeviceID,DriveType,FileSystem,FreeSpace,Size,VolumeName > "%TempFile%.txt"
	type "%TempFile%.txt" > "%TempFile%_ASCII.txt"

	For /F "tokens=1-7 delims= " %%I in ('findstr "[2-4]" "%TempFile%_ASCII.txt"') do (
		rem %%I             %%J       %%K        %%L         %%M           %%N            %%O
		rem Description     DeviceID  DriveType  FileSystem  FreeSpace     Size           VolumeName
		echo %%I	%%J	%%K	%%L	%%M	%%N	%%O
	)

	if exist "%TempFile%.txt" ( del /Q /F "%TempFile%*.txt")
	if exist "%TempFile%_ASCII.txt" ( del /Q /F "%TempFile%_ASCII.txt" )
	set SystemDrive=%O_SystemDrive%
	cd /D %Driver%%FilePath%
	goto End

:ColorSet
	::	1 Normal Text
	set "ClolorBlack_NT=[30m"
	set "ClolorRed_NT=[31m"
	set "ClolorGreen_NT=[32m"
	set "ClolorYellow_NT=[33m"
	set "ClolorBlue_NT=[34m"
	set "ClolorMagenta_NT=[35m"
	set "ClolorCyan_NT=[36m"
	set "ClolorWhite_NT=[37m"

	::	2 Normal Background
	set "ClolorBlack_NB=[40m"
	set "ClolorRed_NB=[41m"
	set "ClolorGreen_NB=[42m"
	set "ClolorYellow_NB=[43m"
	set "ClolorBlue_NB=[44m"
	set "ClolorMagenta_NB=[45m"
	set "ClolorCyan_NB=[46m"
	set "ClolorWhite_NB=[47m"

	::	3 Bright Text
	set "ClolorBlack_BT=[90m"
	set "ClolorRed_BT=[91m"
	set "ClolorGreen_BT=[92m"
	set "ClolorYellow_BT=[93m"
	set "ClolorBlue_BT=[94m"
	set "ClolorMagenta_BT=[95m"
	set "ClolorCyan_BT=[96m"
	set "ClolorWhite_BT=[97m"

	::	4 Bright Background
	set "ClolorBlack_BB=[100m"
	set "ClolorRed_BB=[101m"
	set "ClolorGreen_BB=[102m"
	set "ClolorYellow_BB=[103m"
	set "ClolorBlue_BB=[104m"
	set "ClolorMagenta_BB=[105m"
	set "ClolorCyan_BB=[106m"
	set "ClolorWhite_BB=[107m"

	::	0 DefaultClolor
	set "DefaultClolor=[0m"

	exit /b

:ColorMsg
	echo|set /p=[0m
	exit /b

:Checkdir
	rem ====----	https://stackoverflow.com/questions/18639663/how-to-pass-command-line-parameters-with-space-in-batch-file

	if exist "%*" (
		exit /b
	)
	if not exist "%*" (
		mkdir "%*"
	)
	if exist "%*" (
		echo %* Created
	)
	exit /b

:7z
	rem ====----	parameters 1 2 3 4
	rem ====	mode file outpath file
	if exist %2 (
		echo "%ProgramFiles%\7-Zip\7z.exe" %1 -y %2 -o%3 %4 -p%password% -aoa
		"%ProgramFiles%\7-Zip\7z.exe" %1 -y %2 -o%3 %4 -p%password% -aoa
	) else (
		echo %2
		goto End
	)
	exit /b

:ChkWbem_WMIC
	if not exist "%SystemRoot%\System32\wbem\WMIC.exe" (
		if exist "%SystemDrive%\PortableApps\wbem\WMIC.exe" (
			cd /D "%SystemDrive%\PortableApps\wbem\"
			exit /b
		) else (
			if not exist "%Driver%%FilePath%wbem\WMIC.exe" (
				cd /D "%Driver%%FilePath%"
				curl.exe -LJR --url "https://www.maes.idv.tw/download/Files/Win10_Programs/Win_11/wbem_WMIC/Win24H2_wbem_WMIC.zip" --output "%Driver%%FilePath%Win24H2_wbem_WMIC.zip"  -k --show-error --fail --no-progress-meter
				%ComSpec% /C powershell "Expand-Archive -Path Win24H2_wbem_WMIC.zip -DestinationPath ." -Force
				call :Checkdir "%SystemDrive%\PortableApps\wbem\"
				cd /D %SystemDrive%
				%ComSpec% /C powershell "Expand-Archive -Path Win24H2_wbem_WMIC.zip -DestinationPath '\PortableApps\'" -Force
				cd /D "%Driver%%FilePath%%wbem\"
			)
			if exist "%Driver%%FilePath%wbem\WMIC.exe" (
				cd /D "%Driver%%FilePath%%wbem\"
			)
		)
	)
	exit /b

:Create_TempFile
	rem ====----	TempFile
	set AmTime=%time:~0,2%
	set Time24=%AmTime: =0%
	set TempFile=%TEMP%\%date:~0,4%-%date:~5,2%-%date:~8,2%_%Time24%%time:~3,2%%time:~6,2%%time:~9,2%_tmp

	call :ChkWbem_WMIC
	if exist WMIC.exe (
		WMIC.exe LogicalDisk where ( DriveType^<5 ^) get DeviceID, DriveType, FileSystem, VolumeName ^/VALUE > "%TempFile%.txt"
	)
	if exist "%TempFile%.txt" (
		type "%TempFile%.txt" > "%TempFile%_ASCII.txt"
	) else (
		echo. > "%TempFile%_ASCII.txt"
	)
	exit /b

:IsAdmin
	reg.exe query "HKU\S-1-5-19\Environment" >nul
	if not %ERRORLEVEL% EQU 0 (
		echo uHtκ޲zv
		echo You must have administrator rights to continue ...
		pause & exit
	)
	exit /b

:End
	cd /D "%Driver%%FilePath%"
	%ComSpec% /k