@echo off
:: ===============================================================================
:: AppFileName:	RunRsync.cmd
:: Date:		2024-10-26 22:13:43
:: Version:		1.24.10.26
:: Author:		lsl
:: rsync.exe
:: ===============================================================================
::

rem ====	򥻨tγ]w
set "Driver=%~d0"
set "FilePath=%~p0"
set "ConfFile=%~n0"
set "FullPath=%~f0"

call :IsAdmin
rem reg ADD "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\AppCompatFlags\Layers" /t REG_SZ /f /v "%FullPath%" /d RUNASADMIN
cd /D "%Driver%%FilePath%"

set SourceDriver=%Driver%
set SourceBaseDir=%FilePath%

set BackupDir=\_Backup
set TargetBaseDir=%BackupDir%

set DrvPathConfFile=%Driver%%FilePath%%ConfFile%
set Config_ini=%Driver%%FilePath%%ConfFile%.ini
set Config_cmd=%Driver%%FilePath%%ConfFile%.cmd
set Recovery_cmd=%Driver%%FilePath%%ConfFile%_Recovery.cmd

rem ====	Download7z
set "Download=https://www.7-zip.org/a/7z2408-x64.exe"
set "FileName=7z2408-x64.exe"
call :Download7z

set "AppRoot=%HOMEDRIVE%\PortableApps\cwrsync_6.3.1_x64_free\"
rem %HOMEDRIVE%\PortableApps\cwrsync_6.3.1_x64_free\bin\
set "ImageName=rsync.exe"

rem ====	Downloadcwrsync
	::	2024-09-08
	set Download=https://www.itefix.net/download/free/cwrsync_6.3.1_x64_free.zip
	set FileName=cwrsync_6.3.1_x64_free.zip
	set Version=6.3.1
	set FileDate=2024-07-23
	set "UnZipFile=*"

	set AppName=%FileName:~0,-4%
	set cwRsync_Free=\%AppName%\bin\rsync.exe
	set cwRsync_path=\%AppName%\
	set Program_rsync=%HOMEDRIVE%\%AppName%\bin\rsync.exe
	set cwRsync_Download=%HOMEDRIVE%\PortableApps\%AppName%_cmd\%FileName%
	::
call :Downloadcwrsync

rem ====	GetcwRsyncDiskMsg
:: 2024-09-28
setlocal enabledelayedexpansion
call :GetcwRsyncDiskMsg
setlocal

rem ====	ini_Error	Create_iniFun
if not exist "%Config_ini%" (
	set Target=%LastActiveDisk%
	set cwRsyncDiskStr=%cwRsyncDiskStr%
	set LastcwRsyncDisk=%LastActiveDisk%
	call :ini_Error
)

rem ====	Read  Config_ini
For /F "tokens=1,2 delims==" %%I in ('findstr /i "^[A-z]" "%Config_ini%"') do (
	set %%I=%%J
)

rem ====	_BackupDisk
call :Get_BackupDisk
echo 즳 _Backup ؿϺо: %_BackupDiskStr%	COMPUTERNAME: %COMPUTERNAME%	USERNAME: %USERNAME%
set "TargetDriver=%Target%"

rem ====	DriverLetter
set DriverLetter=%Driver::=%
rem ====	VolumeLabel
call :GetVolumeLabel %Driver%
rem ====----	VolSerialNumber
call :GetVolSerialNumber %Driver%
rem ====----	FreeSpace
call :GetFreeSpace %Driver%

set S_DriverLetter=%DriverLetter%
set S_VolumeLabel=%VolumeLabel%
set S_VolSerialNumber=%VolSerialNumber%

echo ӷϺо: %DriverLetter%	: %VolumeLabel%	Ǹ: %VolSerialNumber%    iΪŶ: %FreeSpace% (TB,GB,MB,KB,Bytes)

rem ====	DriverLetter
set DriverLetter=%Target::=%
rem ====	VolumeLabel
call :GetVolumeLabel %Target%
rem ====----	VolSerialNumber
call :GetVolSerialNumber %Target%
rem ====----	FreeSpace
call :GetFreeSpace %Target%

echo تϺо: %DriverLetter%	: %VolumeLabel%	Ǹ: %VolSerialNumber%    iΪŶ: %FreeSpace% (TB,GB,MB,KB,Bytes)

rem ====----	Source	Target
set "Source=%SourceDriver%%SourceBaseDir%"
set "Target=%TargetDriver%%TargetBaseDir%\%COMPUTERNAME%\%USERNAME%\%S_DriverLetter%\%S_VolumeLabel%\%S_VolSerialNumber%%SourceBaseDir%"

rem ====	exclude
set "SystemVolumeDir=System Volume Information"
set "RECYCLEDir=$RECYCLE.BIN"

rem ====	it ()
set "Source=%Source:^(=^^(%"
set "Source=%Source:^)=^^)%"

set "Target=%Target:^(=^^(%"
set "Target=%Target:^)=^^)%"

rem ====	 :
set "rSource=%Source::=%"
set "rTarget=%Target::=%"

rem ====	[J /cygdrive/
set "rSource=/cygdrive/%rSource%"
set "rTarget=/cygdrive/%rTarget%"

rem ====	m \ /
set "rSource=%rSource:\=/%"
set "rTarget=%rTarget:\=/%"

rem ====	C Yellow
echo.Source [93m%Source%[0m
echo.Target [93m%Target%[0m

echo.rsync Source [93m%rSource%[0m
echo.rsync Target [93m%rTarget%[0m

if %SourceDriver% EQU %TargetDriver% (
	echo [91mӷϺоiMتϺоۦP[0m
	goto End
)

rem ====----	ˬd Target ؿO_sb
call :Checkdir "%Target%"

rem ====	RunAnswer C Green
echo.[92mstart /B/D "%AppRoot%bin" rsync.exe -avrHKtUN "%rSource%" "%rTarget%" --delete [0m
call :RunAnswer "Do you want your computer to run rsync?"  RunRsync

:RunRsync
rem ====----	RunRsync
start /B/D "%AppRoot%bin" rsync.exe -avrHKtUN "%rSource%" "%rTarget%" --exclude="%RECYCLEDir%" --exclude="%SystemVolumeDir%" --delete
echo.

rem ====	C _
call :ColorMsg

rem ====	@wn]wenabledelayedexpansion~౱ܿX
rem ::	RsyncTimeOut	j10
setlocal enabledelayedexpansion

rem ====	RsyncTaskList
call :RsyncTaskList
setlocal

rem ====	
call :ColorMsg

rem ====	RunAnswer RunExplorer O_}ҸƧ
call :RunAnswer "Do you want to run Explorer.exe?"  RunExplorer

goto End

:ini_Error
	echo %Config_ini% file not found.
	call :DiskMessage
	call :ColorMsg
	set Input_edit=
	if /i %LastActiveDisk% EQU %LastcwRsyncDisk%% (
		set /p Input_edit=[45m	Do you want to set Target=%LastActiveDisk% ? Enter yes or no (y/n^):[0m [0m
	) else (
		set /p Input_edit=[45m	Do you want to set Target=%LastcwRsyncDisk% or Target=%LastActiveDisk%? Enter yes or no (y/n^):[0m [0m
	)
	if not '%Input_edit%'=='' set Input_edit=%Input_edit:~0,1%
	if '%Input_edit%'=='' (
		set Target=%LastcwRsyncDisk%
	)
	if /i '%Input_edit%'=='y' (
		set Target=%LastcwRsyncDisk%
	)
	if /i '%Input_edit%'=='n' (
		set Target=%LastActiveDisk%
	)
	set DiskLetter=!ActiveDisk::= !
	if '%Input_edit%'=='' (
		set Input_DISK=%LastcwRsyncDisk::=%
	) else (
		call :UpperFun Input_edit %Input_edit% Input_DISK
	)
	For %%I in (!DiskLetter!) do (
		if /i %%I EQU %Input_DISK% (
			set nTarget=%%I:
		)
	)
	if defined nTarget (
		set Target=!nTarget!
	)
	echo		Target:		   %Target%
	set Input_ini=
	set /p Input_ini=[45m	Do you want to create %Config_ini%? Enter yes or no (y/n^):[0m [0m
	if not '%Input_ini%'=='' set Input_ini=%Input_ini:~0,1%
	if '%Input_ini%'=='' (
		goto Create_iniFun
	)
	if /i '%Input_ini%'=='y' (
		goto Create_iniFun
	) else (
		goto End
	)
	exit /b

:DiskMessage
	echo.
	echo 	Driver 		   %Driver%
	echo 	Target		   %Target%
	echo 	ActiveDiskStr	   %ActiveDiskStr%
	rem echo 	LastActiveDisk	   %LastActiveDisk%
	echo 	cwRsyncDiskStr	   %cwRsyncDiskStr%
	rem echo 	LastcwRsyncDisk	   %LastcwRsyncDisk%

	echo 	BackupDirDiskStr   %BackupDirDiskStr%
	rem echo 	LastBackupDirDisk  %LastBackupDirDisk%
	echo.
	exit /b

:GetcwRsyncDiskMsg
	set ActiveDisk=
	set /a ActiveDisk_n=0
	set cwRsyncDisk=
	set /a cwRsync_n=0
	set BackupDirDisk=
	set /a BackupDirDisk_n=0
	For %%I in (C D E F G H I J K L M N O P Q R S T U V W X Y Z A B) do (
		if /i exist %%I:%SysVolInfo% (
			set "ActiveDisk=!ActiveDisk!%%I: "
			set /a ActiveDisk_n+=1
		)
		if /i exist %%I:%cwRsync_Free% (
			set "cwRsyncDisk=!cwRsyncDisk!%%I: "
			set /a cwRsync_n+=1
		)
		if /i exist %%I:%BackupDir% (
			set "BackupDirDisk=!BackupDirDisk!%%I: "
			set /a BackupDirDisk_n+=1
		)
	)

	set ActiveDiskStr=!ActiveDisk!
	set LastActiveDisk=!ActiveDiskStr:~-3,2!
	set LastcwRsyncDisk=!cwRsyncDisk:~-3,2!
	set LastBackupDirDisk=!BackupDirDisk:~-3,2!

	if defined cwRsyncDisk (
		set cwRsyncDiskStr=!cwRsyncDisk!
	)
	if defined BackupDirDisk (
		set BackupDirDiskStr=!BackupDirDisk!
	)
	exit /b

:Create_iniFun
	echo > "%Config_ini%" >> nul

	echo #/تϺо>> "%Config_ini%"
	echo Target=%Target%>> "%Config_ini%"

	if exist "%Config_ini%" (
		echo "%Config_ini%" already created.
		echo.
		call type "%Config_ini%"
		echo.
	)
	if not exist %Target%\_Backup\%COMPUTERNAME%\nul (
		mkdir %Target%\_Backup\%COMPUTERNAME%
		echo.
	)
	pause & cls
	exit /b

:UpperFun
	set UpperStr=
	For /F "skip=2 delims=" %%I in ('tree "\%~2"') do (
		if not defined %~3 set "%~3=%%I"
		if not defined UpperStr set UpperStr=%%I
	)
	set %~3=%UpperStr:~3%%
	set UpperStr=
	exit /b

:Downloadcwrsync
	if not exist "%AppRoot%bin\%ImageName%" (
		call :Checkdir "%AppRoot%"
		if not exist "%USERPROFILE%\Downloads\%FileName%" (
			echo|set /p="[92m"
			echo curl.exe -LJR --url "%Download%" -o "%USERPROFILE%\Downloads\%FileName%" -k --show-error --fail
			echo|set /p="[0m"
			curl.exe -LJR --url "%Download%" -o "%USERPROFILE%\Downloads\%FileName%" -k --show-error --fail
		)
		if exist "%USERPROFILE%\Downloads\%FileName%" (
			echo|set /p="[92m"
			echo call :7z x "%USERPROFILE%\Downloads\%FileName%" "%AppRoot%" "%UnZipFile%"
			echo|set /p="[0m"
			call :7z x "%USERPROFILE%\Downloads\%FileName%" "%AppRoot%" "%UnZipFile%"
		)
	)
	exit /b

:Download7z
	if not exist "%ProgramFiles%\7-Zip\7z.exe" (
		if not exist "%USERPROFILE%\Downloads\%FileName%" (
			echo|set /p="[92m"
			echo curl.exe -LJR --url "%Download%" -o "%USERPROFILE%\Downloads\%FileName%" -k --show-error --fail
			echo|set /p="[0m"
			curl.exe -LJR --url "%Download%" -o "%USERPROFILE%\Downloads\%FileName%" -k --show-error --fail
		)

		if exist "%USERPROFILE%\Downloads\%FileName%" (
			echo|set /p="[92m"
			echo "%USERPROFILE%\Downloads\%FileName%"  /S
			echo|set /p="[0m"
			"%USERPROFILE%\Downloads\%FileName%"  /S
		)
	)
	exit /b

:7z
	rem ====----	parameters 1 2 3 4
	rem ====	mode file outpath file
	if exist %2 (
		echo|set /p="[92m"
		echo "%ProgramFiles%\7-Zip\7z.exe" %1 -y %2 -o%3 %4 -p%password% -aoa
		echo|set /p="[0m"
		"%ProgramFiles%\7-Zip\7z.exe" %1 -y %2 -o%3 %4 -p%password% -aoa > nul
	) else (
		echo %2
		goto End
	)
	exit /b

:GetVolumeLabel
	For /F "tokens=4 delims= " %%I in ('Vol %~1 ^| findstr /R /C:"%DriverLetter%" ') do (
		set "VolumeLabel=%%I"
	)
	exit /b

:GetVolSerialNumber
	For /F "tokens=2 delims= " %%I in ('Vol %~1 ^| findstr /R /C:":" ') do (
		set "VolSerialNumber=%%I"
	)
	exit /b

:GetFreeSpace
	For /F "tokens=3 delims= " %%I in ('dir %~1\ /w ^| findstr /i "," ') do (
		set "FreeSpace=%%I"
	)
	exit /b

:Get_BackupDisk
	set "_BackupDiskStr="
	For %%I in (C D E F G H I J K L M N O P Q R S T U V W X Y Z A B) do (
		if /i exist "%%I:\_Backup" (
			set "_BackupDiskStr=!_BackupDiskStr!%%I "
		)
	)
	exit /b

:RunAnswer
	set Input_run=
	set /p Input_run=[45m%~1 Enter yes or no (y/n^):[0m [0m
	if not '%Input_run%'=='' set Input_run=%Input_run:~0,1%
	if '%Input_run%'=='' (
		goto %~2
	)
	if /i '%Input_run%'=='y' (
		goto %~2
	) else (
		goto End
	)

	exit /b

:ColorSet
	::	1 Normal Text
	set "ClolorBlack_NT=[30m"
	set "ClolorRed_NT=[31m"
	set "ClolorGreen_NT=[32m"
	set "ClolorYellow_NT=[33m"
	set "ClolorBlue_NT=[34m"
	set "ClolorMagenta_NT=[35m"
	set "ClolorCyan_NT=[36m"
	set "ClolorWhite_NT=[37m"

	::	2 Normal Background
	set "ClolorBlack_NB=[40m"
	set "ClolorRed_NB=[41m"
	set "ClolorGreen_NB=[42m"
	set "ClolorYellow_NB=[43m"
	set "ClolorBlue_NB=[44m"
	set "ClolorMagenta_NB=[45m"
	set "ClolorCyan_NB=[46m"
	set "ClolorWhite_NB=[47m"

	::	3 Bright Text
	set "ClolorBlack_BT=[90m"
	set "ClolorRed_BT=[91m"
	set "ClolorGreen_BT=[92m"
	set "ClolorYellow_BT=[93m"
	set "ClolorBlue_BT=[94m"
	set "ClolorMagenta_BT=[95m"
	set "ClolorCyan_BT=[96m"
	set "ClolorWhite_BT=[97m"

	::	4 Bright Background
	set "ClolorBlack_BB=[100m"
	set "ClolorRed_BB=[101m"
	set "ClolorGreen_BB=[102m"
	set "ClolorYellow_BB=[103m"
	set "ClolorBlue_BB=[104m"
	set "ClolorMagenta_BB=[105m"
	set "ClolorCyan_BB=[106m"
	set "ClolorWhite_BB=[107m"

	::	0 DefaultClolor
	set "DefaultClolor=[0m"

	exit /b

:ColorMsg
	echo|set /p=[0m
	exit/b

:Checkdir
	rem ====----	https://stackoverflow.com/questions/18639663/how-to-pass-command-line-parameters-with-space-in-batch-file

	if exist "%*" (
		exit /b
	)
	if not exist "%*" (
		mkdir "%*"
	)
	if exist "%*" (
		echo %* Created
	)
	exit /b

:7z
	rem ====----	parameters 1 2 3 4
	rem ====	mode file outpath file
	if exist %2 (
		echo "%ProgramFiles%\7-Zip\7z.exe" %1 -y %2 -o%3 %4 -p%password% -aoa
		"%ProgramFiles%\7-Zip\7z.exe" %1 -y %2 -o%3 %4 -p%password% -aoa
	) else (
		echo %2
		goto End
	)
	exit /b

:RsyncTaskList
	rem ::	2024-10-14
	set /a RsyncTimeOut=100
	set /a isTaskList=1
	rem set /a n=0
	rem ====	RsyncTimeOut 100,椤Ny1
	rem :: RsyncTimeOut	ImageName	RsyncImageName isTaskList
	For /L %%I in (0,1,!RsyncTimeOut!) do (
		rem ====	w] 0 X
		set /a isTaskList=0
		rem set /a n+=1
		rem echo.#!n!

		rem ====	tasklist.exe  rsync.exe b椤
		For /F "tokens=1" %%F in ('tasklist.exe /FI "IMAGENAME eq %ImageName%" /NH ^| findstr /R /C:"%ImageName%" ') do (
			set RsyncImageName=%%F
			rem ====	rsync.exe 椤 timeout 1
			if !RsyncImageName! EQU %ImageName% (
				timeout /t 1 /nobreak > nul
				set /a isTaskList=1
			)
		)

		rem ====	X Breaking Out of a For Loop	https://ss64.org/viewtopic.php?t=107
		if !isTaskList! EQU 0 (
			goto BreakLoop
		)
	)
	exit /b

:BreakLoop
	exit /b

:RunExplorer
	call Explorer.exe /root,%Target%
	goto End

:IsAdmin
	reg.exe query "HKU\S-1-5-19\Environment" >nul
	if not %ERRORLEVEL% EQU 0 (
		echo uHtκ޲zv
		echo You must have administrator rights to continue ...
		pause & exit
	)
	exit /b

:End
 	cd /D "%Driver%%FilePath%"
	%ComSpec% /k